<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Vicerrectorado Acad&eacute;mico de la Universidad Nacional de San Mart&iacute;n - UNSM">
    <meta name="keywords" content="UNSM, Vicerrectorado Acad&eacute;mico, Universidad San Mart&iacute;n">
    <meta name="author" content="Universidad Nacional de San Mart&iacute;n">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#359444">

    <title>Vicerrectorado Acad&eacute;mico - UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../../imagenes/escudo unsm.png" sizes="48x48">

    <!-- Stylesheet Principal -->
    <link rel="stylesheet" href="../../css/style.css">
    <!-- Stylesheet Vicerrectorado Acad&eacute;mico -->
    <link rel="stylesheet" href="css/styleVicerec.css">
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="S&iacute;guenos en Facebook" aria-label="P&aacute;gina oficial de Facebook de la UNSM">
                    <img src="../../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="S&iacute;guenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="../../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="../../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="S&iacute;guenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="../../imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="S&iacute;guenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="../../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../../imagenes/logo telefono.png" alt="Tel&eacute;fono" class="contact-icon" width="18" height="18">
                    <span>(+51) (042) 48 0159</span>
                </span>
                <span>
                    <img src="../../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18">
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../../" aria-label="Ir a la p&aacute;gina principal de UNSM">
                    <img src="../../imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Mart&iacute;n" width="auto" height="70">
                </a>
            </div>

            <!-- Bot&oacute;n Hamburguesa para m&oacute;vil -->
            <button class="mobile-menu-toggle" aria-label="Abrir men&uacute; de navegaci&oacute;n" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegaci&oacute;n principal">
                <div class="mobile-nav-logo">
                    <img src="../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="../../#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Men&uacute; Nosotros">
                            <li><a href="../../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../../nosotros/mision/indexMision.php">Nuestra Misi&oacute;n y Visi&oacute;n</a></li>
                            <li><a href="../../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../../nosotros/calendarioAcade/indexCale.php">Calendario Acad&eacute;mico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="../../#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Men&uacute; Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="./">Vicerrectorado Acad&eacute;mico</a></li>
                                <li><a href="../vicerrectorado de investigacion/indexViceRecAca.php">Vicerrectorado de Investigaci&oacute;n</a></li>
                                <li><a href="../secretaria general/indexSecreGene.php">Secretar&iacute;a General</a></li>
                                <li><a href="../planeamiento y presupuesto/indexPlanea.php">Planeamiento y Presupuesto</a></li>
                                <li><a href="../seguridad y salud ocupacional/indexSeguri.php">Seguridad y Salud Ocupacional</a></li>
                                <li><a href="../comunicacion y imagen institucional/indexImagen.php">Comunicaci&oacute;n e Imagen Institucional</a></li>
                                <li><a href="../Cooperacion y Relaciones Internacionales/indexCoopera.php">Cooperaci&oacute;n y Relaciones Internacionales</a></li>
                                <li><a href="../Organo de Control Institucional/indexOrgaConIns.php">&Oacute;rgano de Control Institucional</a></li>
                                <li><a href="../Ejecutora de Inversiones/indexEjec.php">Ejecutora de Inversiones</a></li>
                                <li><a href="../Asesoria Juridica/indexAseJuri.php">Asesor&iacute;a Jur&iacute;dica</a></li>
                                <li><a href="../Grados y Titulos/indexGrados.php">Grados y T&iacute;tulos</a></li>
                            </div>
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Acad&eacute;micas</li>
                                <li><a href="../../#admision">Oficina de Admisi&oacute;n</a></li>
                                <li><a href="../../#asuntos-academicos">Asuntos Acad&eacute;micos</a></li>
                                <li><a href="../../#seguimiento">Seguimiento al Egresado e Inserci&oacute;n Laboral</a></li>
                                <li><a href="../../#tecnologias">Tecnolog&iacute;as de la Informaci&oacute;n</a></li>
                                <li><a href="../../#incubadora">Incubadora de Empresas</a></li>
                                <li><a href="../../#fondo-editorial">Fondo Editorial</a></li>
                                <li><a href="../../#comite-electoral">Comit&eacute; Electoral Universitario</a></li>
                                <li><a href="../../#innovacion">Innovaci&oacute;n y Transferencia Tecnol&oacute;gica</a></li>
                                <li><a href="../../#produccion">Producci&oacute;n de Bienes y Servicios</a></li>
                                <li><a href="../../#responsabilidad">Responsabilidad Social Universitaria</a></li>
                                <li><a href="../../#servicios-generales">Servicios Generales</a></li>
                                <li><a href="../../#bienestar">Bienestar Universitario</a></li>
                                <li><a href="../../#defensoria">Defensor&iacute;a Universitaria</a></li>
                                <li><a href="../../#calidad">Gesti&oacute;n de la Calidad</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../../#admision">ADMISI&Oacute;N</a></li>
                    <li><a href="../../#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../../#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Men&uacute; Facultades">
                            <li class="has-submenu">
                                <a href="../../#ciencias-agrarias" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../../#agronomia">Agronom&iacute;a</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ciencias-salud" aria-haspopup="true" aria-expanded="false">Ciencias de la Salud</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias de la Salud">
                                    <li><a href="../../#obstetricia">Obstetricia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#medicina-veterinaria" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                    <li><a href="../../#medicina-veterinaria-carrera">Medicina Veterinaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ingenieria-agroindustrial" aria-haspopup="true" aria-expanded="false">Ingenier&iacute;a Agroindustrial</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenier&iacute;a Agroindustrial">
                                    <li><a href="../../#ing-agroindustrial">Ingenier&iacute;a Agroindustrial</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ingenieria-civil" aria-haspopup="true" aria-expanded="false">Ingenier&iacute;a Civil y Arquitectura</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenier&iacute;a Civil y Arquitectura">
                                    <li><a href="../../#arquitectura">Arquitectura</a></li>
                                    <li><a href="../../#ingenieria-civil-carrera">Ingenier&iacute;a Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ingenieria-sistemas" aria-haspopup="true" aria-expanded="false">Ingenier&iacute;a de Sistemas e Inform&aacute;tica</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenier&iacute;a de Sistemas">
                                    <li><a href="../../#ing-sistemas">Ingenier&iacute;a de Sistemas e Inform&aacute;tica</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ecologia" aria-haspopup="true" aria-expanded="false">Ecolog&iacute;a</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ecolog&iacute;a">
                                    <li><a href="../../#ing-ambiental">Ingenier&iacute;a Ambiental</a></li>
                                    <li><a href="../../#ing-sanitaria">Ingenier&iacute;a Sanitaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#derecho" aria-haspopup="true" aria-expanded="false">Derecho y Ciencias Pol&iacute;ticas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Derecho">
                                    <li><a href="../../#derecho-carrera">Derecho</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#medicina-humana" aria-haspopup="true" aria-expanded="false">Medicina Humana</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Humana">
                                    <li><a href="../../#medicina-humana-carrera">Medicina Humana</a></li>
                                    <li><a href="../../#enfermeria">Enfermer&iacute;a</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ciencias-economicas" aria-haspopup="true" aria-expanded="false">Ciencias Econ&oacute;micas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Econ&oacute;micas">
                                    <li><a href="../../#administracion">Administraci&oacute;n</a></li>
                                    <li><a href="../../#contabilidad">Contabilidad</a></li>
                                    <li><a href="../../#economia">Econom&iacute;a</a></li>
                                    <li><a href="../../#turismo">Turismo</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#educacion" aria-haspopup="true" aria-expanded="false">Educaci&oacute;n y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educaci&oacute;n">
                                    <li><a href="../../#educacion-inicial">Educaci&oacute;n Inicial</a></li>
                                    <li><a href="../../#educacion-primaria">Educaci&oacute;n Primaria</a></li>
                                    <li><a href="../../#educacion-secundaria">Educaci&oacute;n Secundaria</a></li>
                                    <li><a href="../../#idiomas">Idiomas</a></li>
                                    <li>
                                        <a href="../../#psicologia">
                                            Psicolog&iacute;a
                                            <span class="badge-nuevo">Nuevo</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../../#posgrado">POSGRADO</a></li>
                    <li class="dropdown">
                        <a href="../../#transparencia" aria-haspopup="true" aria-expanded="false">TRANSPARENCIA</a>
                        <ul class="dropdown-menu" aria-label="Men&uacute; Transparencia">
                            <li><a href="../../#licenciamiento">Licenciamiento</a></li>
                            <li><a href="../../#institucional">Institucional Ley 30220</a></li>
                            <li><a href="../../#estandar">Est&aacute;ndar Ley 27806</a></li>
                        </ul>
                    </li>
                </ul>

                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Per&uacute;">
                        <img src="../../imagenes/logo gobPe.png" alt="Gobierno del Per&uacute;" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Per&uacute;">
                    <img src="../../imagenes/logo gobPe.png" alt="Gobierno del Per&uacute;" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Banner Vicerrectorado Acad&eacute;mico -->
    <section class="vicerrectorado-banner">
        <div class="banner-container">
            <h1>VICERRECTORADO ACAD&Eacute;MICO</h1>
            <div class="banner-contact">
                <p><strong>Local Central: Jr. Maynas N&deg; 177, Tarapoto, Per&uacute;</strong></p>
                <p>&#9993; viceacademico@unsm.edu.pe</p>
            </div>
        </div>
    </section>

    <!-- Contenido Principal -->
    <main class="vicerrectorado-main">
        <div class="vicerrectorado-container">
            <!-- Sidebar con tabs -->
            <aside class="vicerrectorado-sidebar">
                <nav class="tabs-menu">
                    <button class="tab-button active" data-tab="funciones">
                        <span class="tab-icon">&#10067;</span>
                        <span class="tab-text">FUNCIONES</span>
                    </button>
                    <button class="tab-button" data-tab="vision">
                        <span class="tab-icon">&#10003;</span>
                        <span class="tab-text">VISI&Oacute;N</span>
                    </button>
                    <button class="tab-button" data-tab="personal">
                        <span class="tab-icon">&#128100;</span>
                        <span class="tab-text">PERSONAL</span>
                    </button>
                    <button class="tab-button" data-tab="organigrama">
                        <span class="tab-icon">&#9783;</span>
                        <span class="tab-text">ORGANIGRAMA</span>
                    </button>
                </nav>
            </aside>

            <!-- Contenido principal -->
            <div class="vicerrectorado-content">
                <!-- Tab de Funciones -->
                <div class="tab-content active" id="funciones">
                    <div class="content-wrapper">
                        <div class="funciones-section">
                            <h2>FUNCIONES</h2>
                            <p class="intro-text">El Vicerrectorado Acad&eacute;mico es el &oacute;rgano de alta direcci&oacute;n responsable de planificar, regular, supervisar y evaluar las actividades acad&eacute;micas de la Universidad, tiene las siguientes funciones:</p>
                            <ul class="funciones-list">
                                <li>Dirigir y ejecutar la pol&iacute;tica general de formaci&oacute;n acad&eacute;mica en la universidad.</li>
                                <li>Presidir el Consejo Universitario y proponer las pol&iacute;ticas para la gesti&oacute;n acad&eacute;mica.</li>
                                <li>Supervisar las actividades acad&eacute;micas con la finalidad de garantizar la calidad acad&eacute;mica y su articulaci&oacute;n con las funciones en concordancia con la misi&oacute;n y metas establecidas por el Estatuto de la Universidad.</li>
                                <li>Dirigir, supervisar y evaluar la implementaci&oacute;n del Reglamento Acad&eacute;mico de la Universidad y dem&aacute;s normas aprobadas.</li>
                                <li>Establecer los lineamientos para la implementaci&oacute;n y la gesti&oacute;n de la capacitaci&oacute;n del personal acad&eacute;mico.</li>
                                <li>Conducir los procesos de admisi&oacute;n permanente del personal docente.</li>
                                <li>Proponer al Consejo Universitario el acceso de ingreso a la Universidad a trav&eacute;s del examen de admisi&oacute;n ordinario, examen de primeros puestos, comunidades nativas, deportistas calificados y otras modalidades alternativas inclusivas.</li>
                                <li>Planificar, organizar, dirigir, supervisar y controlar la implementaci&oacute;n de los planes curriculares y los procesos de formaci&oacute;n profesional, a trav&eacute;s de la tecnolog&iacute;a de informaci&oacute;n, redes de computadoras y equipamiento necesario.</li>
                                <li>Dirigir y supervisar las pol&iacute;ticas, lineamientos y actividades de registro acad&eacute;mico.</li>
                                <li>Las disposiciones referentes al retiro temporal y al retiro del ejercicio.</li>
                                <li>Las dem&aacute;s funciones que otorguen la Ley Universitaria y el Estatuto de la UNSM-T.</li>
                            </ul>

                            <h3 class="subsection-title">Funciones de la secretaria (Nombrada 276)</h3>
                            <ul class="funciones-list">
                                <li>Apoyar en la elaboraci&oacute;n de documentos de competencia del Vicerrectorado.</li>
                                <li>Responsable de atender a las solicitudes y pedidos hechos por las dem&aacute;s dependencias.</li>
                                <li>Recepcionar la documentaci&oacute;n que ingresa y sale del Vicerrectorado Acad&eacute;mico, con el fin de asegurar la continuidad del proceso y evitar los retrasos.</li>
                                <li>Mantener el registro de informaci&oacute;n en el sistema de gesti&oacute;n documentario (SGD).</li>
                                <li>con el prop&oacute;sito de absolver consultas sobre el estado de dichos expedientes.</li>
                                <li>Revisar y preparar la documentaci&oacute;n requerida y generada en el Vicerrectorado Acad&eacute;mico, para ser firmada por el jefe inmediato.</li>
                                <li>Coordinar reuniones, concertar citas, preparar y controlar la agenda del Vicerrectorado Acad&eacute;mico, a fin de que lo tiempos de atenci&oacute;n sea efectiva.</li>
                                <li>Atender al tel&eacute;fono y efectuar llamadas, que permitan establecer las coordinaciones necesarias sobre asuntos que competen los objetivos del</li>
                                <li>Vicerrectorado Acad&eacute;mico.</li>
                                <li>Coordinar el apoyo log&iacute;stico para la realizaci&oacute;n de exposiciones, reuniones u</li>
                                <li>otros eventos a cargo del Vicerrectorado Acad&eacute;mico</li>
                                <li>Seleccionar y clasificar el archivo de la dependencia, coordinando la trasferencia de los documentos al archivo central.</li>
                                <li>Custodiar los bienes/muebles y equipos que se usan en el &aacute;rea de trabajo.</li>
                                <li>Recepcionar, registrar, revisar y distribuir los expedientes en virtual y f&iacute;sico</li>
                                <li>preparado y/o titulado en secretariado del las Facultades.</li>
                                <li>Las dem&aacute;s funciones que delegue el Vicerrectorado Acad&eacute;mico conformidad con los dispositivos legales vigentes.</li>
                            </ul>

                            <h3 class="subsection-title">Funciones del T&eacute;cnico Administrativo (Contratado 276).</h3>
                            <ul class="funciones-list">
                                <li>Elaboraci&oacute;n del Cuadro de Plazas de Docentes para Contratos de Concurso P&uacute;blico.</li>
                                <li>Revisi&oacute;n y Control de Cargos Acad&eacute;micos.</li>
                                <li>Tramites de requerimiento de pasajes, vi&aacute;ticos y rendiciones mediante SIGA.</li>
                                <li>Organizar Talleres de Capacitaciones Acad&eacute;micas.</li>
                                <li>Colaborar en la programaci&oacute;n de actividades t&eacute;cnico - administrativas y en</li>
                                <li>asuntos de trabajo, con el fin de aportar ideas.</li>
                                <li>Solicitar los materiales, herramientas y equipos necesarios del Vicerrectorado Acad&eacute;mico.</li>
                                <li>Apoyo en Secretar&iacute;a.</li>
                                <li>Apoyar a los bienes/inmuebles y equipos que se usan en el &aacute;rea de trabajo</li>
                                <li>Las dem&aacute;s funciones que delegue el jefe inmediato o las que le corresponda de conformidad con los dispositivos legales vigentes.</li>
                            </ul>

                            <h3 class="subsection-title">Funciones de Asistente en seguimiento de presupuesto (T&eacute;rminos de Servicios TDR)</h3>
                            <ul class="funciones-list">
                                <li>Seguimiento del Programa 0066 - Formaci&oacute;n Universitaria de Pregrado</li>
                                <li>Seguimiento del Presupuesto a Nivel de las Facultades.</li>
                                <li>Gestionar y consolidar los requerimientos correspondientes a las dependencias acad&eacute;micas.</li>
                                <li>Elaboraci&oacute;n del Cuadro de Necesidades del Vicerrectorado Acad&eacute;mico</li>
                                <li>Reportes de cumplimiento presupuestal.</li>
                                <li>Reportes sobre temas program&aacute;ticos sobre temas presupuestales</li>
                                <li>Elaborar informes situacional sobre los avances de gastos presupuestarios.</li>
                                <li>Otras funciones que asigne la Vicerrectora Acad&eacute;mica.</li>
                            </ul>
                        </div>

                        <div class="vicerrector-section">
                            <div class="vicerrector-card">
                                <img src="imagenes/VICERRECTOR academico.jpg" alt="Dr. Marco Armando G&aacute;lvez D&iacute;az" class="vicerrector-image">
                                <h3>DR. MARCO ARMANDO G&Aacute;LVEZ D&Iacute;AZ</h3>
                                <p class="vicerrector-title">Vicerrector Acad&eacute;mico</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tab de Visi&oacute;n -->
                <div class="tab-content" id="vision">
                    <div class="content-wrapper">
                        <h2>VISI&Oacute;N</h2>
                        <p>Contenido de la visi&oacute;n del Vicerrectorado Acad&eacute;mico.</p>
                    </div>
                </div>

                <!-- Tab de Personal -->
                <div class="tab-content" id="personal">
                    <div class="content-wrapper">
                        <h2>PERSONAL</h2>
                        <p>Informaci&oacute;n del personal del Vicerrectorado Acad&eacute;mico.</p>
                    </div>
                </div>

                <!-- Tab de Organigrama -->
                <div class="tab-content" id="organigrama">
                    <div class="content-wrapper">
                        <h2>ORGANIGRAMA</h2>
                        <p>Organigrama del Vicerrectorado Acad&eacute;mico.</p>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../../imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios aut&oacute;nomo y de car&aacute;cter estatal, comprometido con la formaci&oacute;n de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N&deg; 177 - Morales</p>
                    <p>Tarapoto - San Mart&iacute;n - Per&uacute;</p>
                    <p>Central Telef&oacute;nica: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces R&aacute;pidos</h3>
                <ul class="footer-links">
                    <li><a href="../../#admision">Admisi&oacute;n</a></li>
                    <li><a href="../../#facultades">Facultades</a></li>
                    <li><a href="../../#posgrado">Posgrado</a></li>
                    <li><a href="../../#investigacion">Investigaci&oacute;n</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="../../#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="../../#campus-virtual">Campus Virtual</a></li>
                    <li><a href="../../#repositorio">Repositorio Institucional</a></li>
                    <li><a href="../../#transparencia">Portal de Transparencia</a></li>
                    <li><a href="../../#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="../../contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <div class="fb-page"
                    data-href="https://www.facebook.com/unsmperu"
                    data-tabs="timeline"
                    data-width="320"
                    data-height="320"
                    data-small-header="false"
                    data-adapt-container-width="true"
                    data-hide-cover="false"
                    data-show-facepile="true">
                    <blockquote cite="https://www.facebook.com/unsmperu" class="fb-xfbml-parse-ignore">
                        <a href="https://www.facebook.com/unsmperu">Universidad Nacional de San Mart&iacute;n - UNSM</a>
                    </blockquote>
                </div>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Mart&iacute;n. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">S&iacute;guenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="../../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="../../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="../../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="../../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="../../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <script src="../../js/script.js" defer></script>
    <script src="js/scriptVicerec.js" defer></script>
    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>
</body>
</html>
